//============================================================================// 
//
// Simple Remake of the original Plugin "AMX Admin Model" by whitemike.
//
// Difference: -) Added a cvar to de/activate the Admin models.
//             -) No need to wait a round until models get changed.
//             -) Fixed model-changing bug.
//	       -) Resets Models when plugin is deactivated.
//
// Change the Access of Admin Models at the line where it says "#define ADMINMODELS ADMIN_XXXX".
// 
// Standard is ADMIN_KICK
//
//
// I recommend using fast download on your server, otherwise it takes forever to download the models.
// 
// 
// INSTALLATION 
//============================================================================//
// 1) Place "simpleadminmodels.amxx" in "cstrike/addons/amxmodx/plugins/".
// 2) Add "simpleadminmodels.amxx" at the bottom of your plugins.ini ("configs/plugins.ini"). 
// 3) Put the "admin_ct" and "admin_te" folders into the "cstrike/models/player/" folder (DO NOT RENAME THEM!!).
// 
//
// CVARs 
//============================================================================// 
// 
// amx_adminmodels "1" = Activated (standard)
//		   "0" = Deactivated
// 
//
//============================================================================//	

#define ADMINMODELS ADMIN_KICK

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <hamsandwich>

//============================================================================//
public plugin_init() 
{
	register_plugin("Simple Admin Models", "1.0", "WhiteBlue")
	RegisterHam(Ham_Spawn, "player", "PlayerSpawn", 1)
	register_cvar("Admin_Models", "1.0", FCVAR_SERVER)
	register_cvar("amx_adminmodels", "1")
}
//============================================================================//
public plugin_precache() 
{
	precache_model("models/player/admin_ct/admin_ct.mdl")
	precache_model("models/player/admin_te/admin_te.mdl")
}
//============================================================================//
public PlayerSpawn(id) 
{
	set_task(1.0, "setModels", id)
		
	return PLUGIN_HANDLED
}	
//============================================================================//
public setModels(id)
{
	if(cs_get_user_team(id) == CS_TEAM_T && get_cvar_num("amx_adminmodels") == 1 && get_user_flags(id) & ADMINMODELS)
	{
		cs_set_user_model(id, "admin_te")
		return PLUGIN_HANDLED
	}
	
	if(cs_get_user_team(id) == CS_TEAM_CT && get_cvar_num("amx_adminmodels") == 1 && get_user_flags(id) & ADMINMODELS)
	{
		cs_set_user_model(id, "admin_ct")
		return PLUGIN_HANDLED
	}
	
	else if(cs_get_user_team(id) == CS_TEAM_T && get_cvar_num("amx_adminmodels") == 0 && get_user_flags(id) & ADMINMODELS)
	{
		cs_set_user_model(id, "arctic")
		return PLUGIN_HANDLED
	}
	
	else if(cs_get_user_team(id) == CS_TEAM_CT && get_cvar_num("amx_adminmodels") == 0 && get_user_flags(id) & ADMINMODELS)
	{
		cs_set_user_model(id, "gign")
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_HANDLED
}
//============================================================================//
